// First, both events must be registered inside the macro.

RegisterEvent(MidiNoteOn, OnMidiNoteOn);
RegisterEvent(MidiNoteOff, OnMidiNoteOff);

// We also have to fetch the fixture type ID of our Deskchannel fixture to be able to access it. 

int nTypeId;
nTypeId = GetFixtureTypeId(Dskch);
if (nTypeId < 0)
{
	alert(Fixture Type does not exist! Aborting...\n);
	exit;
}

// The most important part is calling the Suspend command to let the macro lay itself to sleep.

Suspend();

// Finally, the functions that are to be called must be written. Both functions have to receive 3 int parameters. Were
// keeping it simple here, so only one Desk Channel fixture will be altered. 

function OnMidiNoteOn(int p0, int p1, int p2)
{
	proClear();
	proSelectSingle(nTypeId, 1);
	SetPosition(65535);
	proLoadValue(0);
}

function OnMidiNoteOff(int p0, int p1, int p2)
{
	proClear();
	proSelectSingle(nTypeId, 1);
	SetPosition(0);
	proLoadValue(0);
}

