int i, k, count, manual_found, myProperty;
string message, list;

for (i = 0; i < 255; i++)
{
	count = CueGetCount(i);
	if (count > 0)
	{
		for (k = 0; k < count; k++)
		{
			if(CueGetProperty(i, k, "Command") == 0) 
			{
				manual_found = 1;
				list += format("- Cuelist %d
					(%s), Cue %d (%s)\n"),
					i + 11, 
					GetCuelistName(i), k+1, 
					CueGetName(i, k));
			}
		}
	}
}

// SECOND PART OF THE MACRO

if (manual_found)
{
	message="Manual timing found in the following cuelists:\n\n";
	message+=list;
	MessageWarning(message);
}
else 
	MessageOk("Show OK!\nNo manual timings found.");
 
// THIRD PART OF THE MACRO
if (manual_found)
{
	message = "Manual timing found in the following cuelists:\n\n";
	message += list;
	message += "\nWould you like to set them to WAIT=1 second?";
	if(MessageYesNo(message))
	{
		for (i=0; i<255; i++)
		{
			count = CueGetCount(i);
			if (count>0)
			{
				for (k=0;  k<count;  k++)
				{
					if(CueGetProperty(i, k, "Command") == 0) 
					{
						CueSetProperty(i, k, "Command", 1);
						CueSetProperty(i, k, "Para0", 1000);
					}
				}
			}
		}
	}
	else exit;
}
else MessageOk("Show OK!\nNo manual timings found.");
